const express = require("express");

const { authenticateToken } = require("../middleware/authMiddleware");
const { getScripts, getScriptsPerIds, addScript, updateScript, updateScriptOnOff, deleteScript} = require("../controllers/scriptController");
    
const router = express.Router();

// Route to fetch all events
router.get("/get-scripts", authenticateToken, getScripts); // New route for fetching events

// Route to fetch all events
router.post("/add-script", authenticateToken, addScript); // New route for fetching events

// Route to update an event by its ID
router.put("/update-script/:id", authenticateToken, updateScript);

// Route to delete an existing script by its ID
router.delete("/delete-script/:id", authenticateToken, deleteScript); // DELETE method to delete a script by ID

// Route to update the on_off status of an existing script by its ID
router.put("/update-script-onoff/:id", authenticateToken, updateScriptOnOff); // PUT method to update the on_off status


// Public routes - No need of authentication ----------

// Route to fetch all events
router.get("/get-scripts-per-ids", getScriptsPerIds); // New route for fetching events


module.exports = router;
